-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p1 = Citadels.GetPlayer(1)
            
    if not self.loaded then
      self.active = false
      self.attNum = -1
      self.timer = 4
    end    
    
    self.armyDestroyed:LinkToTarget("reinfTargetActive")
		self.activateHandlers:LinkToTarget("activateAttHandler")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      HandleRetreat(self)
      self.timer = 4
    end    
  end  
end

function HandleRetreat(self)
	attUnits = self.p1:CheckUnitsCount(6, 1)
  
  if not attUnits then
    if self.attNum == 2 then
			self.armyDestroyed:TriggerAllTargets()
    else
			self.activateHandlers:TriggerAllTargets()
		end
    self.active = false
  else
    return
  end  
end

function OnTrigger(self, source, target)
  if target == "retHandler" then
    if source == "meadowWave" then
			self.attNum = 0
		elseif source == "valleyWave" then
      self.attNum = 1
		elseif source == "lakeWave" then
      self.attNum = 2
		end
  end
	self.active = true
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.attNum = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.attNum)
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("retHandler")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("activateHandlers")
	self:AddTriggerSource("armyDestroyed")
end
